<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\ExchangeResets;

// plugin root
define('__PATH_EXCHANGERESETS_ROOT__', __PATH_PLUGINS__.'exchangeresets/');

// plugin home
define('__EXCHANGERESETS_HOME__', __BASE_URL__.'exchangeresets/');

// admincp
$extra_admincp_sidebar[] = array(
    'Exchange Resets', array(
        array('Settings','exchangeresets&page=settings'),
        array('Exchange Packages','exchangeresets&page=packages'),
        array('Logs','exchangeresets&page=logs')
    )
);

if(file_exists(__PATH_EXCHANGERESETS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_EXCHANGERESETS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading exchange resets language file.');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_EXCHANGERESETS_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading exchange resets language file.');
}

// load classes
if(!@include_once(__PATH_EXCHANGERESETS_ROOT__ . 'classes/class.exchangeresets.php')) throw new Exception(lang('exchangeresets_error_1', true));